#!/bin/bash

#######################################################################
####           Video-Mobiloptimiert-FFMPEG                         ####
#######################################################################

## Autor: Joachim Jakob
## benötigt: Linux oder macOS; ffmpeg

## Anwenden:
## $ unzip video-mobiloptimiert-ffmpeg.zip
## $ cd video-mobiloptimiert-ffmpeg
## $ chmod +x video-mobiloptimiert-ffmpeg.sh
## Alle Videodateien die umgewandelt werden sollen,
## kopieren in das Unterverzeichnis
## originaldateien 
## $ ./video-mobiloptimiert-ffmpeg.sh

## in dieses Verzeichnis werden die Original-Videodateien hineinkopiert
originaldateien_verz='originaldateien'

## Videodateien mit diesen Dateiendungen werden verkleinert und ggf. nach MP4 konvertiert
declare -a endungen
endungen=('mp4' 'ogg' 'mpg' 'avi' 'mkv' 'm4v' 'mov' 'webm')

## hier liegen nach der Skriptdurchführung die 
ausgabe_verz='ausgabedateien'

## der Pfad zur Library FFMPEG oder LIBAV auf dem System
prog='/usr/bin/ffmpeg'

## das Ziel-Containerformat, Standard: mp4
zielendung='mp4'

## die Ziel-Auflösung Breite und Höhe für Wide 360p
#zielbreite=640
#zielhoehe=360
praefix='conv_'

## alle vier Auflösungen von 1080p (= Full HD) bis  Wide 360p
## '1920x1080' '1280x720' '854x480' '640x360'
aufloesungen=('1280x720' '640x360')
echo $aufloesungen
## Ausgangsauflösung ermitteln
## ffprobe -v error -select_streams v:0 -show_entries stream=width,height -of csv=s=x:p=0 input.mp4

## zusätzliche Einstellungen, ca. 5% größere Zieldatei
## ggf. vor den Audio-Codec-Eigenschaften unten einfügen
## https://encodingwissen.de/codecs/x264/referenz/#preset-kompressionsvorlage-star
## Standard: nicht gesetzt (bei slow dauert die Umwandlung länger)
## https://encodingwissen.de/codecs/x264/referenz/#crf-qualitatsfaktor-star
## Standard: -crf 23 (höherer Wert, geringere Qualität, untere Wahrnehmungsgrenze bei 18)
## -preset slow -crf 20
## Farbe: -pix_fmt yuv420p (rechnet langsamer)
## evtl. redundant zu -s bxh bzw. -s:v bxh
## -vf scale=${zielbreite}:${zielhoehe}

## Verzeichnisse anlegen sofern nicht vorhanden
if [ ! -d "${originaldateien_verz}" ] ; then
    mkdir "${originaldateien_verz}"
fi 

if [ ! -d "${ausgabe_verz}" ] ; then
    mkdir "${ausgabe_verz}"
fi 

## ins Originaldateienverzeichnis wechseln
cd ${originaldateien_verz}
pwd


## für alle Endung
for endung in "${endungen[@]}" ; do
    ## für jede Datei mit dieser Endung
    for infile in *.${endung} ; do 
        #echo "#### Endung: $endung"
        dateiname=${infile%.*}
        ## für alle Auflösungen
        for aufloesung in "${aufloesungen[@]}" ; do
            #echo "Auflösung: ${aufloesung}"
            zielbreite=$(echo ${aufloesung} | awk -Fx '{print $1}')
            zielhoehe=$(echo ${aufloesung} | awk -Fx '{print $2}')
            #echo "Zielhöhe: ${zielbreite} ; Zielbreite: ${zielhoehe}"
            $prog -i "${infile}" -movflags faststart -c:v libx264 -c:a aac -b:a 128k -s:v ${zielbreite}x${zielhoehe} "$praefix${dateiname}_${zielhoehe}p.${zielendung}"
        done
    done
done
## verschieben
mv ${praefix}*.mp4 ../${ausgabe_verz}/


