// Globale Variablen und Arrays definieren
var qIdx    = 0;
var correct = 0;
var howMany = units.length; // ggfs. als Zahl anpassen!
var keeper  = new Array();
var rank    = new Array(
    'Du brauchst dringend Hilfe! Frage bei Unklarheiten stets nach und wiederhole die Grundlagen!',
    'Hmmmmm - nur wenige habe noch schlechter abgschnitten - arbeite den Stoff nochmals komplett durch!',
    'Leider liegen nur bruchstückhafte Kenntnisse vor, wiederhole das komplette Kapitel!',
    'Nur ein Teil der Inhalte wurde gekonnt, fülle die noch vorhandenen Lücken auf!',
    'Reicht gerade aus, sollte aber unbedingt noch ausgebaut werden!',
    'Schon ganz gut, über aber weiter!',
    'Nicht schlecht, aber für ein Spitzenergebnis fehlen noch die Feinheiten ☺',
    'Sehr gute, solide Leistung ☺☺',
    'Du hast eine außergewöhnlich gute Leistung erreicht ☺☺☺'
);
var starthinweis='Wähle für jede Frage die eine richtige Antwortmöglichkeit aus. Viel Erfolg!';
var stopOK   = false;
var nextQ    = '';
var results  = '';

// Funktion zum Mischen der Fragen (und Antworten)
function mischen() {
    for (var i = 0; i < units.length; i++) {
        var j = Math.floor(Math.random() * units.length);
        var tempUnit = units[i];
        units[i] = units[j];
        units[j] = tempUnit;
        }
    }

// Zurücksetzen, im Falle eines Wiederholungsdurchlaufs
function werteZuruecksetzen() {
    qIdx     = 0;
    correct  = 0;
    stopOK   = false;
    keeper   = new Array();
    mischen();
    }

// Testfragen anwenden und die Antworten aufzeichnen
function erzeugeFrage() {
    if (qIdx == howMany) { 

        // Aufruf der Bewertungsfunktion
        gradeTest(); 
        return; 
        }

    // Schreiben der Fragen und Antortmöglichkeiten in den Frame
    zeigeStatistik('Frage '+(qIdx + 1)+' von '+howMany);
    nextQ = '<span class="fragentext">'+units[qIdx].question+'</span><form>'+ 
    erzeugeAuswahlknopf('a', units[qIdx].a)+
    erzeugeAuswahlknopf('b', units[qIdx].b)+
    erzeugeAuswahlknopf('c', units[qIdx].c)+
    erzeugeAuswahlknopf('d', units[qIdx].d)+
    '</form>';
    $('#questions').html(nextQ);
    // MathJax eneut aufrufen zum Aktualisieren der Ansicht
    MathJax.Hub.Typeset();
    
    // Zählvariable um eins erhöhen für die nächste Frage
    qIdx++;

    // Vorzeitiges Beenden nach mindestens zwei Fragen erlauben
    if(qIdx >= 2 && !stopOK) {
        stopOK = true; 
    }
}

function erzeugeAuswahlknopf(optLtr, optAnswer) {
    return '<label for="'+optLtr+'" class="radio"><input id="'+optLtr+'" type="radio" name="antworten" value="'+optLtr+'" onclick="keeper[qIdx - 1]=this.value; erzeugeFrage();" />'+optAnswer+'</label>';
}

function zeigeWarnhinweis() {
    if (stopOK) {
        $('#warnhinweis').removeAttr('hidden');
    }
}

function vorzeitigBeenden() {
    $('#warnhinweis').attr('hidden', 'hidden');
    gradeTest();
}

function gradeTest() {
    // Vergleich der gegebenen Antworten mit den richtigen Lösungen
    for (var i = 0; i < qIdx; i++) {
        if (keeper[i] == units[i].answer) {
            correct++;
            }
        }

    // Ausgabe des Testergebnisses und übergabe der Ranking-Einstrufung als Parameter
    var idx = Math.ceil((correct/howMany) * rank.length - 1) < 0 ? 0 : Math.ceil((correct/howMany) * rank.length - 1);
    zeigeErgebnisse(rank[idx]);
    werteZuruecksetzen;
    }

// Ausgabe der Fragen, der Antwortmöglichkeiten sowie der Erklärungshinweise
function zeigeErgebnisse(ranking) {
    zeigeStatistik('Du hast '+correct+' von '+howMany+' richtig beantwortet.');
    // Ergebnisse etwas hübsch verpacken
    results = '<b>Bewertung: <i>'+ranking+'</i><br />Fahre mit dem Mauszeiger über den roten Text, um die Erklärungen für die falsch beantworteten Fragen anzuzeigen.</b>' + 
    '<br /><br />Hier sind die Ergebnisse im Einzelnen:<br /><br />';

    // Jedes Frage-Antwortpaar zur Ergebnisvariablen hinzufügen
    for (var i = 0; i < howMany; i++) {
        results += '<b>Frage '+(i + 1)+'</b><br />'+ 
            units[i].question + '<br /><br />\n<span class="kleiner">'+
            'a. '+units[i].a+'<br />'+
            'b. '+units[i].b+'<br />'+ 
            'c. '+units[i].c+'<br />'+ 
            'd. '+units[i].d+'<br /></span>';

        // Für jede Frage entscheiden, ob diese richtig beantwortet wurde und diese dann entsprechend darstellen
        if (keeper[i] == units[i].answer) {
            results += '<b><i><span class="richtig">Diese Frage wurde richtig beantwortet ('+keeper[i]+').</span></i></b>\n<br /><br /><br />';
            }        
        else {
            results += '<b><i><span class="falsch" id="f'+i+'" href="">Die richtige Antwort lautet: '+units[i].answer+'</span></i></b><br /><br /><br />'; // " title="'+units[i].support+')"
        }
    }
    $('#questions').html(results);
    // MathJax eneut aufrufen zum Aktualisieren der Ansicht
    MathJax.Hub.Typeset();
    // Nur den falschen Antworten die Tooltips hinzufügen
    for (var i = 0; i < howMany; i++) {
        if (keeper[i] != units[i].answer) {
            var tooltipinhalt=String(units[i].support);
            $('span#f'+i).data('powertip', $('<p class="mehrzeilig">'+tooltipinhalt+'</p>'));
            $('span#f'+i).powerTip({
                placement:'ne',
                smartPlacement:true,
                followMouse:false
                //mouseOnToPopup: true
            });
            
        }
    }
}

// Statistische Angaben während des Durchlaufs anzeigen
function zeigeStatistik(str) {
    $('#statistik').html(str);
}

// Den Seiteninhalt in den Originalzustand zurückversetzen
function zurueckSetzen() {
    $('#statistik').html('&nbsp;');
    $('#questions').html(starthinweis);
}

