var zeichenflaeche = document.getElementById('zeichenflaeche'),
    zeichnungs_zeichenflaeche = zeichenflaeche.getContext('2d'),
    hintergrund_zeichenflaeche = document.createElement('canvas').getContext('2d'),
    auswahl_linienstaerke = document.getElementById('auswahl_linienstaerke'),
    alles_loeschen_knopf = document.getElementById('alles_loeschen_knopf'),
    bildschirmfoto_knopf = document.getElementById('bildschirmfoto_knopf'),
    meine_steuerungselemente = document.getElementById('meine_steuerelemente'),
    b_steuerelemente_ausblenden = document.getElementById('b_steuerelemente_ausblenden'),
    bildexport_behaelter=document.getElementById('bildexport_behaelter'),
    eingeblendet='an',
    titel_b_steuerelemente_ausblenden=document.getElementById('titel_b_steuerelemente_ausblenden'),
    
    // Automatische Größenanpassung der Zeichenfläche
    verfuegbare_breite=parseInt(window.innerWidth)-64, // screen.availWidth falls Fenstergröße: window.innerWidth,
    verfuegbare_hoehe=window.innerHeight-2, // screen.availHeight falls Fenstergröße: window.innerHeight,
    standard_breite=300,
    standard_hoehe=240,
    start_linienstaerke=3, 
    aktuelle_linienstaerke=parseInt(auswahl_linienstaerke.value),
    aktuelle_deckkraft=1,
    aktuelle_farbe='yellow',
    vollbild=false,
    drawingSurfaceImageData,

    ziehen = false,
    mousedown = {},
    letztes_rechteck = {},
    lastX, lastY,

    kontroll_punkt = {},
    bearbeitungs_kurve = false,
    ziehen_kontrollpunkt = false,
    kurven_start = {},
    kurven_ende = {},
   
    fuelle_flaechen = false, //Flächen nicht ausfüllen
    ausgewaehltes_rechteck = null,
    ausgewaehlte_funktion,
    
    gummiband_linienbreite = 4,
    gummiband_linienfarbe = 'green',

    radiergummi_linienbreite = 1,
    radiergummi_schattenstil = '#d3d3d3', 
    radiergummi_linienstil =  '#d3d3d3', //'rgba(0,0,255,0.2)'
    radiergummi_schattenabstand = 0, // -5
    radiergummi_schattenbreite = 0, // 10
    radiergummi_radius = 25;

// Steuerelemente................................................

function zeige_titel(wer) {
    document.getElementById('titel_'+wer).style.display='block';
}

function verberge_titel(wer) {
    document.getElementById('titel_'+wer).style.display='none';
}

var eingabetypauswahl_ids=[
    'path', 'erase', 'line'
];

function setze_eingabetyp(wer) {
    //setze_canvas();
    ausgewaehlte_funktion=wer;
    for (var i=0; i < eingabetypauswahl_ids.length; i++) {
        $('#'+eingabetypauswahl_ids[i]).removeClass('gerade_aktiv');   
    }
    $('#'+wer).addClass('gerade_aktiv');
}

var farbauswahlbutton_ids=[
    'darkblue', 'blue', 'green', 'red',  'orange', 'purple', 'black', 'gray', 'yellow',
     'magenta', 'cyan', 'black', 'white'
] 
//RGBA-Farben mit Transparenz

function setze_farbe(wer) {
    //setze_eingabetyp('path');
    var farben_transparent={
        'red':'rgba(255, 0, 0, '+aktuelle_deckkraft+')',
        'black':'rgba(0, 0, 0, '+aktuelle_deckkraft+')',
        'white':'rgba(255, 255, 255, '+aktuelle_deckkraft+')',
        'orange':'rgba(255, 165, 0, '+aktuelle_deckkraft+')',
        'yellow':'rgba(255, 255, 0, '+aktuelle_deckkraft+')',
        'green':'rgba(0, 128, 0, '+aktuelle_deckkraft+')',
        'darkblue':'rgba(0, 0, 139, '+aktuelle_deckkraft+')',
        'magenta':'rgba(255, 0, 255, '+aktuelle_deckkraft+')',
        'blue':'rgba(0, 0, 255, '+aktuelle_deckkraft+')',
        'cyan':'rgba(0, 255, 255, '+aktuelle_deckkraft+')',
        'gray':'rgba(179, 179, 179, '+aktuelle_deckkraft+')'
    }
    aktuelle_farbe=wer;
    zeichnungs_zeichenflaeche.strokeStyle=farben_transparent[wer];
    zeichnungs_zeichenflaeche.fillStyle=farben_transparent[wer];
}

function setze_linienstaerke(wert) {
    //setze_eingabetyp('path');
    aktuelle_linienstaerke=wert;
    zeichnungs_zeichenflaeche.lineWidth=parseInt(aktuelle_linienstaerke);
}

function setze_deckkraft(wert) {
    //setze_eingabetyp('path');
    aktuelle_deckkraft=wert;
    zeichnungs_zeichenflaeche.deckkraft=parseFloat(aktuelle_deckkraft);
    var farben_transparent={
        'red':'rgba(255, 0, 0, '+aktuelle_deckkraft+')',
        'black':'rgba(0, 0, 0, '+aktuelle_deckkraft+')',
        'white':'rgba(255, 255, 255, '+aktuelle_deckkraft+')',
        'orange':'rgba(255, 165, 0, '+aktuelle_deckkraft+')',
        'yellow':'rgba(255, 255, 0, '+aktuelle_deckkraft+')',
        'green':'rgba(0, 128, 0, '+aktuelle_deckkraft+')',
        'darkblue':'rgba(0, 0, 139, '+aktuelle_deckkraft+')',
        'magenta':'rgba(255, 0, 255, '+aktuelle_deckkraft+')',
        'blue':'rgba(0, 0, 255, '+aktuelle_deckkraft+')',
        'cyan':'rgba(0, 255, 255, '+aktuelle_deckkraft+')',
        'gray':'rgba(179, 179, 179, '+aktuelle_deckkraft+')'
    }
    zeichnungs_zeichenflaeche.strokeStyle=farben_transparent[aktuelle_farbe];
    zeichnungs_zeichenflaeche.fillStyle=farben_transparent[aktuelle_farbe];
}


// Saving/Restoring the drawing surface..........................

function speichere_zeichenflaeche() {
   //console.log('speichere_zeichenflaeche: width='+zeichenflaeche.width+' height='+zeichenflaeche.height);
   drawingSurfaceImageData = zeichnungs_zeichenflaeche.getImageData(0, 0,
                             zeichenflaeche.width,
                             zeichenflaeche.height);
}

function stelle_zeichenflaeche_wieder_her() {
   //console.log('stelle_zeichenflaeche_wieder_her: '+drawingSurfaceImageData);
   zeichnungs_zeichenflaeche.putImageData(drawingSurfaceImageData, 0, 0);
}

// Radiergummi........................................................

// http://stackoverflow.com/questions/7909865/canvas-fill-a-rectangle-in-all-areas-that-are-fully-transparent/7916842#7916842
// http://stackoverflow.com/questions/10396991/clearing-circular-regions-from-html5-canvas
// http://stackoverflow.com/questions/3564717/html5-canvas-clear-arc-method

var cutCircle = function(context, x, y, radius){
    context.globalCompositeOperation = 'destination-out'
    context.arc(x, y, radius, 0, Math.PI*2, true);
    context.fill();
}




function pfad_fuer_radiergummi_setzen() {
   zeichnungs_zeichenflaeche.beginPath();
   zeichnungs_zeichenflaeche.moveTo(lastX, lastY);
   zeichnungs_zeichenflaeche.arc(lastX, lastY,
                      radiergummi_radius + radiergummi_linienbreite,
                      0, Math.PI*2, false);
}

function attribute_fuer_radiergummi_setzen() {
  zeichnungs_zeichenflaeche.lineWidth     = radiergummi_linienbreite;
  zeichnungs_zeichenflaeche.shadowColor   = radiergummi_schattenstil;
  zeichnungs_zeichenflaeche.shadowOffsetX = radiergummi_schattenabstand; 
  zeichnungs_zeichenflaeche.shadowOffsetY = radiergummi_schattenabstand;
  zeichnungs_zeichenflaeche.shadowBlur    = radiergummi_schattenbreite;
  zeichnungs_zeichenflaeche.strokeStyle   = radiergummi_linienstil;
}

function letztes_ausradieren() {
   var x = lastX - radiergummi_radius-radiergummi_linienbreite,
       y = lastY - radiergummi_radius-radiergummi_linienbreite,
       w = radiergummi_radius*2+radiergummi_linienbreite*2,
       h = w,
       cw = zeichnungs_zeichenflaeche.canvas.width,
       ch = zeichnungs_zeichenflaeche.canvas.height;

   zeichnungs_zeichenflaeche.save();

   pfad_fuer_radiergummi_setzen();
   zeichnungs_zeichenflaeche.clip();

      if (x + w > cw) w = cw - x;
      if (y + h > ch) h = ch - y;

      if (x < 0) { x = 0; }
      if (y < 0) { y = 0; }

      zeichnungs_zeichenflaeche.drawImage(
         hintergrund_zeichenflaeche.canvas, x, y, w, h, x, y, w, h);

   zeichnungs_zeichenflaeche.restore();
}

function zeichne_radiergummi(loc) {
   zeichnungs_zeichenflaeche.save();
   attribute_fuer_radiergummi_setzen();     

   //zeichnungs_zeichenflaeche.beginPath();
   //zeichnungs_zeichenflaeche.arc(loc.x, loc.y, radiergummi_radius, 0, Math.PI*2, false);
   
   
   cutCircle(zeichnungs_zeichenflaeche, loc.x, loc.y, radiergummi_radius, 0, Math.PI*2); // context, x, y, radius
   
   //zeichnungs_zeichenflaeche.clip();
   //zeichnungs_zeichenflaeche.stroke();

   zeichnungs_zeichenflaeche.restore();
}

// Funktionen zur Ereignis-Behandlung......................................

function windowToCanvas(canvas, x, y) {
   var bbox = canvas.getBoundingClientRect();
   return { x: x - bbox.left * (canvas.width  / bbox.width),
            y: y - bbox.top  * (canvas.height / bbox.height)
          };
}

// Event handler für Tastendrücke............................................

function enter() {
  setze_url();
};

document.onkeydown = function (e) {
   if (e.ctrlKey || e.metaKey || e.altKey)
      return;

   else if (e.keyCode === 13) {
      enter();
   }
}
   
document.onkeypress = function (e) {
   var key = String.fromCharCode(e.which);

   if (e.ctrlKey || e.metaKey || e.altKey)
      return;

}


function mouseDownOrTouchStartInzeichenflaeche(loc) {
   ziehen = true;

   if (bearbeitungs_kurve) {
      if (zeichnungs_zeichenflaeche.isPointInPath(loc.x, loc.y)) {
         ziehen_kontrollpunkt = true;
      }
      else {
         stelle_zeichenflaeche_wieder_her();
      }
      bearbeitungs_kurve = false;
   }

   if (!ziehen_kontrollpunkt) {
      speichere_zeichenflaeche();
      mousedown.x = loc.x;
      mousedown.y = loc.y;
   
      if (ausgewaehlte_funktion === 'path' || ausgewaehlte_funktion === 'pathClosed') {
         zeichnungs_zeichenflaeche.beginPath();
         zeichnungs_zeichenflaeche.moveTo(loc.x, loc.y);               
      }   

      lastX = loc.x;
      lastY = loc.y;
   }
}

function moveControlPoint(loc) {
   kontroll_punkt.x = loc.x;
   kontroll_punkt.y = loc.y;
}

function mouseMoveOrTouchMoveInzeichenflaeche(loc) {
   if (ziehen_kontrollpunkt) {
      stelle_zeichenflaeche_wieder_her();

      moveControlPoint(loc);

      zeichnungs_zeichenflaeche.save();

      zeichnungs_zeichenflaeche.strokeStyle = gummiband_linienfarbe;
      zeichnungs_zeichenflaeche.lineWidth = gummiband_linienbreite;

      drawCurve();
      drawControlPoint();

      zeichnungs_zeichenflaeche.restore();
   }
   else if (ziehen) {
      if (ausgewaehlte_funktion === 'erase') {
         letztes_ausradieren();
         zeichne_radiergummi(loc);
      }
      else if (ausgewaehlte_funktion === 'path' ||
               ausgewaehlte_funktion === 'pathClosed') {
         zeichnungs_zeichenflaeche.lineTo(loc.x, loc.y);
         zeichnungs_zeichenflaeche.stroke();
      }
      else { // For lines, circles, rectangles, and curves, draw rubberbands
         stelle_zeichenflaeche_wieder_her();
         //hilfslinien_rechteck_aktualisieren(loc);
         //hilfslinie_zeichnen(loc);   
      }

      lastX = loc.x;
      lastY = loc.y;
   
      //letztes_rechteck.w = hilfeslinieW;
      //letztes_rechteck.h = hilfeslinieH;
   }

   if (ziehen || ziehen_kontrollpunkt) {
       if (ausgewaehlte_funktion === 'line' ||
           ausgewaehlte_funktion === 'rectangle' ||
           ausgewaehlte_funktion === 'circle') {
         zeichne_fuehrungsdraehte(loc.x, loc.y);
      }
   }
};

/******************************************************************************/

// Fuehrungsdrähte....................................................

function zeichne_horizontale_linie (y) {
   zeichnungs_zeichenflaeche.beginPath();
   zeichnungs_zeichenflaeche.moveTo(0, y+0.5);
   zeichnungs_zeichenflaeche.lineTo(zeichenflaeche.width, y+0.5);
   zeichnungs_zeichenflaeche.stroke();
}

function zeichne_vertikale_linie (x) {
   zeichnungs_zeichenflaeche.beginPath();
   zeichnungs_zeichenflaeche.moveTo(x+0.5, 0);
   zeichnungs_zeichenflaeche.lineTo(x+0.5, zeichenflaeche.height);
   zeichnungs_zeichenflaeche.stroke();
}

function zeichne_fuehrungsdraehte(x, y) {
   zeichnungs_zeichenflaeche.save();
   zeichnungs_zeichenflaeche.strokeStyle = 'rgba(0,0,230,0.4)';
   zeichnungs_zeichenflaeche.lineWidth = 0.5;
   zeichne_vertikale_linie(x);
   zeichne_horizontale_linie(y);
   zeichnungs_zeichenflaeche.restore();
}

// Das Zeichnen von Linien, Kreisen und Rechtecken abschließen.................

function zeichnen_linie_abschliessen(loc) {   
   zeichnungs_zeichenflaeche.beginPath();
   zeichnungs_zeichenflaeche.moveTo(mousedown.x, mousedown.y);
   zeichnungs_zeichenflaeche.lineTo(loc.x, loc.y);
   zeichnungs_zeichenflaeche.stroke();
}
/******************************************************************************/

function beende_pfad(loc) {
   zeichnungs_zeichenflaeche.lineTo(loc.x, loc.y);
   zeichnungs_zeichenflaeche.stroke();
                 
   if (ausgewaehlte_funktion === 'pathClosed') {
      zeichnungs_zeichenflaeche.closePath();

      if (fuelle_flaechen) {
         zeichnungs_zeichenflaeche.fill();
      }
      zeichnungs_zeichenflaeche.stroke();
   }
}

function mouseUpOrTouchEndInzeichenflaeche(loc) {
   if (ausgewaehlte_funktion !== 'erase' && ausgewaehlte_funktion !== 'slinky') {
      stelle_zeichenflaeche_wieder_her();
   }

   if (ziehen_kontrollpunkt) {
      moveControlPoint(loc);
      finishDrawingCurve();
      ziehen_kontrollpunkt = false;
   }
   else if (ziehen) {
      if (ausgewaehlte_funktion === 'erase') { 
         letztes_ausradieren(); 
      }
      else if (ausgewaehlte_funktion === 'path' ||
               ausgewaehlte_funktion === 'pathClosed') { 
         beende_pfad(loc);
      }
      else {
         if (ausgewaehlte_funktion === 'line')           zeichnen_linie_abschliessen(loc);
         else if (ausgewaehlte_funktion === 'rectangle') zeichnen_rechteck_abschliessen();
         else if (ausgewaehlte_funktion === 'circle')    zeichnen_kreis_abschliessen(loc);
         else if (ausgewaehlte_funktion === 'curve')     startEditingCurve(loc);
     }
   }
   ziehen = false;
};

// Event handler der Zeichenfläche.................................

zeichenflaeche.onmousedown = function (e) {
   var x = e.x || e.clientX,
       y = e.y || e.clientY;

   e.preventDefault();
   mouseDownOrTouchStartInzeichenflaeche(
      windowToCanvas(zeichenflaeche, x, y));
}

zeichenflaeche.ontouchstart = function (e) { 
   if (e.touches.length === 1) {
      e.preventDefault();
      mouseDownOrTouchStartInzeichenflaeche(
         windowToCanvas(zeichenflaeche,
            e.touches[0].clientX, e.touches[0].clientY));
   }
}

zeichenflaeche.ontouchmove = function (e) { 
   if (e.touches.length === 1) {
      mouseMoveOrTouchMoveInzeichenflaeche(
         windowToCanvas(zeichenflaeche,
            e.touches[0].clientX, e.touches[0].clientY));
   }
}

zeichenflaeche.ontouchend = function (e) { 
   var loc;
   
   if (e.changedTouches.length === 1) {
      loc = windowToCanvas(zeichenflaeche, e.changedTouches[0].clientX, e.changedTouches[0].clientY);
      mouseUpOrTouchEndInzeichenflaeche(loc);
   }
}

zeichenflaeche.onmousemove = function (e) {
   var x = e.x || e.clientX,
       y = e.y || e.clientY,
     loc = windowToCanvas(zeichenflaeche, x, y);

   e.preventDefault();
   mouseMoveOrTouchMoveInzeichenflaeche(loc);
}

zeichenflaeche.onmouseup = function (e) {
   var x = e.x || e.clientX,
       y = e.y || e.clientY,
     loc = windowToCanvas(zeichenflaeche, x, y);

   e.preventDefault();
   mouseUpOrTouchEndInzeichenflaeche(loc);
}

// Event handler von Steuerelementen........................................

auswahl_linienstaerke.onchange = function (e) {
   try {
       zeichnungs_zeichenflaeche.lineWidth = parseInt(auswahl_linienstaerke.value);
   } catch (f) {
       console.log('Fehler: '+f);
   }
};

auswahl_deckkraft.onchange = function (e) {
   try {
       zeichnungs_zeichenflaeche.deckkraft = parseFloat(auswahl_deckkraft.value);
       aktuelle_deckkraft=zeichnungs_zeichenflaeche.deckkraft;
       setze_deckkraft(aktuelle_deckkraft);
   } catch (f) {
       console.log('Fehler: '+f);
   }
};

alles_loeschen_knopf.onclick = function (e) {
    var abfrage=confirm('Wirklich die gesamte bisherige Beschriftung löschen?');
    if (abfrage) {
        zeichnungs_zeichenflaeche.clearRect(0,0,
                                           zeichenflaeche.width,
                                           zeichenflaeche.height);
    } else {
        alert('Das Löschen des Zeichenflächeninhalts wurde abgebrochen.');
    }
};


bildschirmfoto_knopf.onclick = function (e) {  
   speichere_als_html();
};

$(window).resize(neue_canvasgroesse);

function neue_canvasgroesse() {
    var randleistenbreite=64;
    var fensterbreite=window.innerWidth;
    var fensterhoehe=window.innerHeight;
    var canvasbreite=fensterbreite-randleistenbreite;
    var verfuegbare_fensterhoehe=fensterhoehe-2;
    groesse_anpassen(canvasbreite, verfuegbare_fensterhoehe);
    
    //console.log('neue_canvasgroesse - stelle_zeichenflaeche_wieder_her');
    //stelle_zeichenflaeche_wieder_her();
    aktuelle_linienstaerke=parseInt(auswahl_linienstaerke.value);
    aktuelle_deckkraft=parseFloat(auswahl_deckkraft.value);
    setze_linienstaerke(aktuelle_linienstaerke);
    setze_deckkraft(aktuelle_deckkraft);
}

function speichere_als_html() {
    var speichertypauswahl=window.prompt('Gib hier p für PopUp (DragAndDrop in Textfeld möglich) oder s für Speichern (als Datei) ein:', 'p');
    //console.log('speichere_als_html');
    if (speichertypauswahl == 's') {
        var dateiname_kurz=ermittle_dateiname();
        zeichenflaeche.toBlob(function(blob) {
            saveAs(blob, dateiname_kurz+'.png');
        }, 'image/png');
    } else if (speichertypauswahl == 'p') {
        /*Variante als PopUp-Fenster*/
        var dateiinhalt_als_dataurl=zeichenflaeche.toDataURL();
        //alert(dateiinhalt_als_dataurl);
        var popup_seitenquelltext='<!DOCTPYE HTML>\n'+
                                  '<html>\n'+
                                  '  <head>\n'+
                                  '    <meta charset="utf-8">\n'+
                                  '    <style>\n'+
                                  '      body, p, img {\n'+
                                  '      width:300px;\n'+
                                  '      height:240px;\n'+
                                  '      margin:0px;\n'+
                                  '      padding:0px;\n'+
                                  '    }\n'+
                                  '    </style>\n'+
                                  '  </head>\n'+
                                  '  <body>\n'+
                                  '    <p><img src="'+dateiinhalt_als_dataurl+'" /></p>\n'+
                                  '  </body>\n'+
                                  '</html>';
        var popup_als_dataurl='data:text/html;charset=UTF-8;base64,'+window.btoa(unescape(encodeURIComponent(popup_seitenquelltext)));
        window.open(popup_als_dataurl, '_blank', "menubar=no,location=no,status=no,toolbar=no,scrollbars=no,width=300,height=240,left=0,top=0");
    } else {
        alert('Der Speichervorgang wurde abgebrochen.');
    }
}

function ermittle_dateiname() {
    var stammname=prompt('Gib hier den Dateinamen ein: ');
    if (stammname) {
        stammname=stammname.replace(/\s+/g, '_');
    } else {
        stammname='SimpleBoard_Marker';
    }
    var aktuelle_zeit=new Date();
    var jahr=aktuelle_zeit.getFullYear();
    var monat=aktuelle_zeit.getMonth();
    var tag=aktuelle_zeit.getDate();
    var stunde=aktuelle_zeit.getHours();
    var minuten=aktuelle_zeit.getMinutes();
    var sekunden=aktuelle_zeit.getSeconds();
    if (monat < 10) {
        monat = '0'+monat;
    }
    if (tag < 10) {
        tag = '0'+tag;
    }
    if (stunde < 10) {
        stunde = '0'+stunde;
    }
    if (minuten < 10) {
        minuten = '0'+minuten;
    }
    if (sekunden < 10) {
        sekunden = '0'+sekunden;
    }
    var zeitanzeigeanhang='_'+jahr+'-'+monat+'-'+tag+'_'+stunde+'-'+minuten+'-'+sekunden
    var dateiname_kurz=stammname+zeitanzeigeanhang;
    return dateiname_kurz;
}


function zeichne_hintergrund() {
   hintergrund_zeichenflaeche.canvas.width = zeichnungs_zeichenflaeche.canvas.width;
   hintergrund_zeichenflaeche.canvas.height = zeichnungs_zeichenflaeche.canvas.height;
}

// Startwerte................................................

function groesse_anpassen(neue_breite, neue_hoehe) {
    // Automatische Größenanpassung der Zeichenfläche
    speichere_zeichenflaeche();
    zeichenflaeche.width=neue_breite;
    zeichenflaeche.height=neue_hoehe;
    stelle_zeichenflaeche_wieder_her();
}


if (vollbild) {
    // Automatische Größenanpassung beim Start
    var randleistenbreite=64;
    var fensterbreite=window.innerWidth;
    var fensterhoehe=window.innerHeight;
    var canvasbreite=fensterbreite-randleistenbreite;
    var verfuegbare_fensterhoehe=fensterhoehe-2;
    
    zeichenflaeche.width=canvasbreite;
    zeichenflaeche.height=verfuegbare_fensterhoehe;
    //console.log('Breite: '+verfuegbare_breite+' Höhe: '+verfuegbare_hoehe);
} else {
    var randleistenbreite=64;
    var fensterbreite=window.innerWidth;
    var fensterhoehe=window.innerHeight;
    var canvasbreite=fensterbreite-randleistenbreite;
    var verfuegbare_fensterhoehe=fensterhoehe-2;
    zeichenflaeche.width=canvasbreite;
    zeichenflaeche.height=verfuegbare_fensterhoehe;
}

zeichnungs_zeichenflaeche.strokeStyle = 'darkblue';
zeichnungs_zeichenflaeche.fillStyle = 'darkblue';

auswahl_linienstaerke.value=start_linienstaerke;
zeichnungs_zeichenflaeche.lineWidth = auswahl_linienstaerke.value;
zeichnungs_zeichenflaeche.deckkraft = auswahl_linienstaerke.value;
ausgewaehlte_funktion = 'path';
setze_eingabetyp('path')

// Bei Touch-Geräten das Scrollen des devices from
// sichtbaren Bildschirmausschnitts verhindern

document.body.addEventListener('touchmove', function (e) {
   e.preventDefault();
}, false);

zeichne_hintergrund();
