#!/bin/bash

## https://askubuntu.com/questions/1288879/installed-firefox-to-migrate-from-classic-installation-to-snap
## https://fullstackdevelopment.de/linux/286/ultimative-loesung-des-problems-der-nutzerrechte-in-var-www-html/

## Vorbereitung:
## sudo apt install bindfs
## in der Datei /etc/fuse.conf aktivieren:
## user_allow_other

### Profilverzeichnis:
## früher: $HOME/.mozilla/firefox
## snap:   $HOME/snap/firefox/common/.mozilla/firefox

## killall firefox

browser='/snap/bin/firefox'
tempdir=$(mktemp -d -t browser-temp-profile.XXXXXXXXXX)
tempdir_name=$(basename ${tempdir})
snapdir="${HOME}/snap/firefox/common/.mozilla/firefox/tempprofiles/${tempdir_name}"
if [ ! -d ${snapdir} ] ; then
    mkdir -p ${snapdir}
fi

chown -Rv ${USER}.${USER} ${tempdir}
chmod -Rv 0777 ${tempdir}

bindfs ${tempdir} ${snapdir}
seite='https://startpage.com/'
tempverz="${snapdir}" #$(mktemp -d -p ${snapdir} -t browser-temp-profile.XXXXXXXXXX)
## Für Entwickler praktisch:
##   --devtools \
echo "## snapdir: ${snapdir}"
echo "## tempdir: ${tempdir}"
echo "## mountbefehl: bindfs ${tempdir} ${snapdir}"
echo "## tempverz: ${tempverz}"
echo "## Firefox wird gestartet mit temporärem Profil"
${browser} \
  --profile "${tempverz}" \
  --no-remote \
  --new-instance \
  ${seite}


## alle temporären FF-Profile:
## ${HOME}/snap/firefox/common/.mozilla/firefox/tempprofiles/browser-temp-profile.XXXXXXXXXX

